<!-- Affiche le header -->
<?php get_header(); ?>

<div class="action-header">
    <div class="container">
        <div class="action-header__item action-header__item--search">
            <form>
                <input type="text" class="hidden-sm hidden-xs" placeholder="Search for articles, comments and people"><!-- For desktop -->
                <input type="text" class="visible-xs visible-sm" placeholder="Search..."><!-- For desktop -->
            </form>
        </div>

        <div class="action-header__item action-header__item--tags hidden-xs">
            <a href="">#New York</a>
            <a href="">#Condo for rent</a>
            <a href="">#Lendors</a>
            <a href="" class="hidden-sm">#Mortgage</a>
            <a href="" class="hidden-sm">#Sell Property</a>
        </div>
    </div>
</div>

<section class="section">
    <div class="container">
        <header class="section__title">
            <h2>Duis mollisest non commodo luctus nisierat porttito</h2>
            <small>Vestibulum id ligula porta felis euismod semper</small>
        </header>

        <div class="row">
            <div class="col-md-8 col-sm-7">

            	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

	                <article class="card">
	                	
	                	<?php if ( has_post_thumbnail() ) : ?>
	                    
		                    <a class="card__img" href="<?php the_permalink(); ?>">
		                    	<?php the_post_thumbnail(); ?>
		                    </a>

	                    <?php endif; ?>

	                    <div class="card__header">
	                        <h2><?php the_title(); ?></h2>
	                        <small>by <?php the_author(); ?> on <?php the_time( get_option( 'date_format' ) ); ?></small>
	                    </div>
	                    <div class="card__body">

	                        <?php the_content(); ?>

	                        <div class="blog-more">
	                            <a href="<?php the_permalink(); ?>">Read More...</a>
	                        </div>
	                    </div>
	                </article>

                <?php endwhile; else: ?>
    
					<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
    
				<?php endif; ?>

                <nav class="text-center">
                    <ul class="pagination">
                        <li>
                            <a href="#" aria-label="Previous">
                                <i class="zmdi zmdi-chevron-left"></i>
                            </a>
                        </li>
                        <li class="active"><a href="#">1</a></li>
                        <li><a href="#">2</a></li>
                        <li><a href="#">3</a></li>
                        <li><a href="#">4</a></li>
                        <li><a href="#">5</a></li>
                        <li>
                            <a href="#" aria-label="Next">
                                <i class="zmdi zmdi-chevron-right"></i>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <?php get_sidebar(); ?>
            
        </div>
    </div>
</section>

<!-- Affiche le footer -->
<?php get_footer(); ?>